/*jslint node: true, nomen: true, unparam: true */
/*global jquery, $, _, define, Marionette, jqm, window */

'use strict';

define([ 'Portal', 'backbone', 'marionette', 'jquery', 'core/models/Model', 'modules/user-navigation/userNavigationItemView', 'hbs!modules/user-navigation/userNavigation'],
    function (Portal, Backbone, Marionette, $, Model, UserNavigationItemView, template) {
        return Backbone.Marionette.CompositeView.extend({
            template : template,
            itemView: UserNavigationItemView,
            itemViewContainer: "#user-nav-toplist",
            initialize : function () {
                var that = this;
                Portal.commands.setHandler("open-user-menu", function(){
                    that.openMenu();
                });
                Portal.vent.on('close:popups', function () {
                    that.closeMessages();
                }); 
                $(Portal.userMenuRegion.el).popup({
                    positionTo: "#user-menu",   // The anchor the popup is attached too.
                    shadow: true,                  // Shadow around popup
                    transition: "fade",              // How to animate in.
                    corners: false,                 // No rounded Edges
                    tolerance: "41,0",              // Edges from window
                    dismissible: true               // Click anywhere to close.
                });
            },            openMenu: function () {
                this.$el.trigger('create');
                $(Portal.userMenuRegion.el).popup('open');
            },
            closeMessages: function (e) {
                $(Portal.userMenuRegion.el).popup('close');
            }
        });
    });
